
#version 410
#define tex1D texture
#define tex3D texture
#define LUT_POS(x, lut_size) mix(0.5 / (lut_size), 1.0 - 0.5 / (lut_size), (x))
out vec4 out_color;
in vec2 texcoord0;
in vec2 texcoord1;
uniform mat3 colormatrix;
uniform vec3 colormatrix_c;
uniform vec3 src_luma;
uniform vec3 dst_luma;
uniform mat3 cms_matrix;
uniform sampler2DRect texture0;
uniform vec2 texture_size0;
uniform mat2 texture_rot0;
uniform vec2 texture_off0;
uniform vec2 pixel_size0;
uniform sampler2DRect texture1;
uniform vec2 texture_size1;
uniform mat2 texture_rot1;
uniform vec2 texture_off1;
uniform vec2 pixel_size1;
float hable(float x) {
    return ((x * (0.150000*x + 0.050000)+0.004000)/(x * (0.150000*x + 0.500000) + 0.060000)) - 0.066667;
}
void main() {
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    color.r = 1.000000 * vec4(texture(texture0, texcoord0)).r;
    color.gb = 1.000000 * vec4(texture(texture1, texcoord1)).rg;
    color = color.rgbr;
    color.rgb = mat3(colormatrix) * color.rgb + colormatrix_c;
    color.a = 1.0;
    // color mapping
    // linearize
    color.rgb = clamp(color.rgb, 0.0, 1.0);
    color.rgb = pow(color.rgb, vec3(1.0/78.843750));
    color.rgb = max(color.rgb - vec3(0.835938), vec3(0.0))
    / (vec3(18.851562) - vec3(18.687500) * color.rgb);
    color.rgb = pow(color.rgb, vec3(1.0/0.159302));
    color.rgb *= vec3(100.000000);
    color.rgb *= vec3(1.0/100.000000);
    color.rgb *= vec3(100.000000);
    color.rgb = cms_matrix * color.rgb;
//    [0] = ([0] = 1.66049695, [1] = -0.587656736, [2] = -0.0728399455)
//    [1] = ([0] = -0.124547064, [1] = 1.13289523, [2] = -0.0083479844)
//    [2] = ([0] = -0.0181536824, [1] = -0.100597292, [2] = 1.11875105)
    
    // HDR tone mapping
    float sig = max(max(color.r, color.g), color.b);
    float sig_peak = 100.000000;
    float sig_avg = 0.250000;
    float sig_orig = sig;
    float slope = min(1.0, 0.250000 / sig_avg);
    sig *= slope;
    sig_peak *= slope;
    float luma = dot(dst_luma, color.rgb);
    float coeff = max(sig - 0.180000, 1e-6) / max(sig, 1e-6);
    coeff = pow(coeff, 20.000000);
    color.rgb = mix(color.rgb, vec3(luma), coeff);
    sig = mix(sig, luma * slope, coeff);
    sig = hable(sig) / hable(sig_peak);
    sig = min(sig, 1.0);
    color.rgb *= vec3(sig / sig_orig);
    color.rgb *= vec3(1.000000);
    // delinearize
    color.rgb = clamp(color.rgb, 0.0, 1.0);
    color.rgb *= vec3(1.000000);
    color.rgb = pow(color.rgb, vec3(1.0/2.2));
    out_color = color;
}

#version 410
#define tex1D texture
#define tex3D texture
#define LUT_POS(x, lut_size) mix(0.5 / (lut_size), 1.0 - 0.5 / (lut_size), (x))
out vec4 out_color;
in vec2 texcoord0;
in vec2 texcoord1;
uniform mat3 colormatrix;
uniform vec3 colormatrix_c;
uniform vec3 src_luma;
uniform mat3 cms_matrix;
uniform sampler2DRect texture0;
uniform vec2 texture_size0;
uniform mat2 texture_rot0;
uniform vec2 texture_off0;
uniform vec2 pixel_size0;
uniform sampler2DRect texture1;
uniform vec2 texture_size1;
uniform mat2 texture_rot1;
uniform vec2 texture_off1;
uniform vec2 pixel_size1;
void main() {
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    color.r = 1.000000 * vec4(texture(texture0, texcoord0)).r;
    color.gb = 1.000000 * vec4(texture(texture1, texcoord1)).rg;
    color = color.rgbr;
    color.rgb = mat3(colormatrix) * color.rgb + colormatrix_c;
    color.a = 1.0;
    // color mapping
    // linearize
    color.rgb = clamp(color.rgb, 0.0, 1.0);
    color.rgb = pow(color.rgb, vec3(1.0/78.843750));
    color.rgb = max(color.rgb - vec3(0.835938), vec3(0.0))
    / (vec3(18.851562) - vec3(18.687500) * color.rgb);
    color.rgb = pow(color.rgb, vec3(1.0/0.159302));
    color.rgb *= vec3(100.000000);
    color.rgb *= vec3(1.0/100.000000);
    color.rgb *= vec3(100.000000);
    color.rgb = cms_matrix * color.rgb;
    color.rgb *= vec3(1.000000);
    // delinearize
    color.rgb = clamp(color.rgb, 0.0, 1.0);
    color.rgb *= vec3(1.000000);
    color.rgb = pow(color.rgb, vec3(1.0/2.2));
    out_color = color;
}

#version 410
#define tex1D texture
#define tex3D texture
#define LUT_POS(x, lut_size) mix(0.5 / (lut_size), 1.0 - 0.5 / (lut_size), (x))
out vec4 out_color;
in vec2 texcoord0;
in vec2 texcoord1;
uniform mat3 colormatrix;
uniform vec3 colormatrix_c;
uniform vec3 src_luma;
uniform vec3 dst_luma;
uniform sampler2DRect texture0;
uniform vec2 texture_size0;
uniform mat2 texture_rot0;
uniform vec2 texture_off0;
uniform vec2 pixel_size0;
uniform sampler2DRect texture1;
uniform vec2 texture_size1;
uniform mat2 texture_rot1;
uniform vec2 texture_off1;
uniform vec2 pixel_size1;
void main() {
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    color.r = 1.000000 * vec4(texture(texture0, texcoord0)).r;
    color.gb = 1.000000 * vec4(texture(texture1, texcoord1)).rg;
    color = color.rgbr;
    color.rgb = colormatrix * color.rgb + colormatrix_c;
    color.a = 1.0;
    // color mapping
    color.rgb *= vec3(1.000000);
    color.rgb *= vec3(1.000000);
    out_color = color;
}
