#version 150

in vec2 v_texcoord;
out vec4 outColor;

uniform sampler2D inputTexture;
uniform float fNormalizeMin;
uniform float fNormalizeMul;
uniform float progress;

void main() {
    vec4 originColor = texture(inputTexture, v_texcoord);
    
    float step_res = step(progress, v_texcoord.x);
    vec3 normalizeRgb = (originColor.rgb - vec3(fNormalizeMin)) * fNormalizeMul;
    originColor = mix(vec4(normalizeRgb, 1.0), originColor, step_res);
    
    outColor = originColor;
}
