//
//  rgbFragmentShader.fsh
//
//
//  Created by luguilong .
//  Copyright xlplayer 2016. All rights reserved.
//

// 在OpenGL3.2 Core Profile中，版本号必须显式地给出
#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
#else 
varying vec2 v_texcoord;
#endif

uniform sampler2D SamplerY;
uniform sampler2D SamplerUV;
uniform mat3 colorConversionMatrix;

#if __VERSION__ >= 140
out highp vec4 myOutput;
#else 
varying vec4 myOutput;
#endif

void main()
{
    mediump vec3 yuv;
    lowp vec3 rgb;
    
    // Subtract constants to map the video range start at 0
    #if __VERSION__ >= 140
    yuv.x = (texture(SamplerY, v_texcoord).r - (16.0 / 255.0));
    yuv.yz = (texture(SamplerUV, v_texcoord).rg - vec2(0.5, 0.5));
    #else
    yuv.x = (texture2D(SamplerY, v_texcoord).r - (16.0 / 255.0));
    yuv.yz = (texture2D(SamplerUV, v_texcoord).rg - vec2(0.5, 0.5));
    #endif
    
    rgb = colorConversionMatrix * yuv;
    
    #if __VERSION__ >= 140
    myOutput = vec4(rgb, 1);
    #else
    gl_FragColor = vec4(rgb, 1);
    #endif
}
