#version 150

#if __VERSION__ >= 140
in vec4 position;
in vec2 texcoord;
#else
attribute vec4 position;
attribute vec2 texcoord;
#endif

uniform mat4 modelViewProjectionMatrix;

uniform float aspect;

#if __VERSION__ >= 140
out vec2 v_texcoord;
#else
varying vec2 v_texcoord;
#endif

void main()
{
    vec4 tranPos = position;
    tranPos.x = tranPos.x * aspect;
    tranPos = modelViewProjectionMatrix * tranPos;
    tranPos.x = tranPos.x / aspect;
    gl_Position = tranPos;
    v_texcoord = texcoord.xy;
}
