
#version 150

#if __VERSION__ >= 140
in vec4 position;
in vec2 texcoord;
#else
attribute vec4 position;
attribute vec2 texcoord;
#endif

#if __VERSION__ >= 140
out vec2 v_texcoord;

#else
varying vec2 v_texcoord;

#endif

uniform mat4 modelViewProjectionMatrix;

void main()
{
    gl_Position = modelViewProjectionMatrix * position;
    v_texcoord = texcoord.xy;
    
}

