
#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4  myOutPut;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D inputTexture;
uniform vec2 leftTop;
uniform vec2 leftBottom;
uniform vec2 rightTop;
uniform vec2 rightBottom;
uniform float rectangleL;//左边界
uniform float rectangleR;//右边界
uniform float rectangleT;//上边界
uniform float rectangleB;//下边界

float lineStep(float minVal, float maxVal, float var) {
    float res;
    return res;
}

void main() {
    
    vec4 originColor = texture(inputTexture, v_texcoord);
    vec2 textureCoordinate = v_texcoord;
    
    vec2 coord1 = textureCoordinate;
    vec2 coord2 = textureCoordinate;
    vec2 coord3 = textureCoordinate;
    vec2 coord4 = textureCoordinate;
    
    highp float L = rectangleL;
    highp float R = rectangleR;
    highp float T = rectangleT;
    highp float B = rectangleB;
    const float factor = 0.02;
    const float extra = 0.02;
    L -= extra;
    R += extra;
    T -= extra;
    B += extra;
    if (textureCoordinate.x > L && textureCoordinate.x < R && textureCoordinate.y > T && textureCoordinate.y < B) {
        coord1 = vec2(textureCoordinate.x, T);
        coord2 = vec2(textureCoordinate.x, B);
        coord3 = vec2(L, textureCoordinate.y);
        coord4 = vec2(R, textureCoordinate.y);
    }
    vec4 colorT = texture(inputTexture, coord1);
    vec4 colorB = texture(inputTexture, coord2);
    vec4 colorL = texture(inputTexture, coord3);
    vec4 colorR = texture(inputTexture, coord4);
    
    float blurSmoothFactorX = smoothstep(L, R, textureCoordinate.x);
    float blurSmoothFactorY = smoothstep(T, B, textureCoordinate.y);
    
    vec4 verticalBlend = mix(colorT, colorB, blurSmoothFactorY);
    vec4 horizontalBlend = mix(colorL, colorR, blurSmoothFactorX);
    
    vec4 rectangleBlendColor = mix(verticalBlend, horizontalBlend, 0.5);
    

    float blurIntensity = 1.0 - smoothstep(L, L + factor, textureCoordinate.x);
    blurIntensity += smoothstep(R - factor, R, textureCoordinate.x);

    float blurIntensity2 = 1.0 - smoothstep(T, T + factor, textureCoordinate.y);
    blurIntensity2 += smoothstep(B - factor, B, textureCoordinate.y);

    
    vec4 resBlendColor = mix(rectangleBlendColor, originColor, blurIntensity2);
    resBlendColor = mix(resBlendColor, originColor, blurIntensity);
    
    
#if __VERSION__ >= 140
    myOutPut = resBlendColor;
#else
    gl_FragColor = newColor;
#endif
}
