#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4 myOutput;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D s_texture;

/** Contrast ranges from 0.0 to 4.0 (max contrast), with 1.0 as the normal level */
uniform float contrast;

/** Saturation ranges from 0.0 (fully desaturated) to 2.0 (max saturation), with 1.0 as the normal level */
uniform float saturation;
const vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);

/** Exposure ranges from -10.0 to 10.0, with 0.0 as the normal level */
uniform float exposure;

void main()
{
#if __VERSION__ >= 140
    vec4 textureColor = texture(s_texture, v_texcoord);
#else
    vec4 textureColor = texture2D(s_texture, v_texcoord);
#endif
    
    vec4 newColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), textureColor.w);;
    
    float luminance = dot(newColor.rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    newColor = vec4(mix(greyScaleColor, textureColor.rgb, saturation), textureColor.w);
    
    newColor = vec4(textureColor.rgb * pow(2.0, exposure), textureColor.w);
    
#if __VERSION__ >= 140
    myOutput = newColor;
#else
    gl_FragColor = newColor;
#endif
}

