
#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4 myOutput;

#else
varying vec2 v_texcoord;

#endif

uniform float wStep;
uniform float hStep;

uniform sampler2D s_texture;

uniform float sharpness;

void main()
{
    
    
    vec2 widthStep = vec2(wStep, 0.0);
    vec2 heightStep = vec2(0.0, hStep);
    vec2 leftTextureCoordinate = v_texcoord.xy - widthStep;
    vec2 rightTextureCoordinate = v_texcoord.xy + widthStep;
    vec2 topTextureCoordinate = v_texcoord.xy + heightStep;
    vec2 bottomTextureCoordinate = v_texcoord.xy - heightStep;

    float centerMultiplier = 1.0 + 4.0 * sharpness;
    float edgeMultiplier = sharpness;
    
    #if __VERSION__ >= 140
        vec3 textureColor = texture(s_texture, v_texcoord).rgb;
        vec3 leftTextureColor = texture(s_texture, leftTextureCoordinate).rgb;
        vec3 rightTextureColor = texture(s_texture, rightTextureCoordinate).rgb;
        vec3 topTextureColor = texture(s_texture, topTextureCoordinate).rgb;
        vec3 bottomTextureColor = texture(s_texture, bottomTextureCoordinate).rgb;
    #else
        vec3 textureColor = texture2D(s_texture, v_texcoord).rgb;
        vec3 leftTextureColor = texture2D(s_texture, leftTextureCoordinate).rgb;
        vec3 rightTextureColor = texture2D(s_texture, rightTextureCoordinate).rgb;
        vec3 topTextureColor = texture2D(s_texture, topTextureCoordinate).rgb;
        vec3 bottomTextureColor = texture2D(s_texture, bottomTextureCoordinate).rgb;
    #endif
    
    vec4 newColor = vec4((textureColor * centerMultiplier - (leftTextureColor * edgeMultiplier + rightTextureColor * edgeMultiplier + topTextureColor * edgeMultiplier + bottomTextureColor * edgeMultiplier)), 1.0);
    
    
#if __VERSION__ >= 140
    myOutput = newColor;
#else
    gl_FragColor = newColor;
#endif
}

