//
//  yuvFragmentShader.fsh
//
//
//  Created by luguilong on.
//  Copyright xlplayer 2016. All rights reserved.
//

// 在OpenGL3.2 Core Profile中，版本号必须显式地给出
#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4  myOutPut;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D s_texture_y;
uniform sampler2D s_texture_u;
uniform sampler2D s_texture_v;

uniform float brightness;
uniform float contrast;
uniform float saturate;
uniform float gamma;
uniform float huee;

const vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);

const highp  vec4  kRGBToYPrime = vec4 (0.299, 0.587, 0.114, 0.0);
const highp  vec4  kRGBToI     = vec4 (0.595716, -0.274453, -0.321263, 0.0);
const highp  vec4  kRGBToQ     = vec4 (0.211456, -0.522591, 0.31135, 0.0);

const highp  vec4  kYIQToR   = vec4 (1.0, 0.9563, 0.6210, 0.0);
const highp  vec4  kYIQToG   = vec4 (1.0, -0.2721, -0.6474, 0.0);
const highp  vec4  kYIQToB   = vec4 (1.0, -1.1070, 1.7046, 0.0);

void main()
{
    #if __VERSION__ >= 140
     float y = texture(s_texture_y, v_texcoord).r - 0.0625;
     float u = texture(s_texture_u, v_texcoord).r - 0.5;
     float v = texture(s_texture_v, v_texcoord).r - 0.5;
    #else
     float y = texture2D(s_texture_y, v_texcoord).r - 0.0625;
     float u = texture2D(s_texture_u, v_texcoord).r - 0.5;
     float v = texture2D(s_texture_v, v_texcoord).r - 0.5;
    #endif
    
    lowp vec3 rgb;
    rgb.r = 1.1643 * y + 1.596 * v;
    rgb.g = 1.1643 * y - 0.391 * u - 0.813 * v;
    rgb.b = 1.1643 * y + 2.018 * u;
    
    
    if (huee != 0) {
        // Convert to YIQ
        highp float   YPrime  = dot (vec4(rgb, 1.0), kRGBToYPrime);
        highp float   I       = dot (vec4(rgb, 1.0), kRGBToI);
        highp float   Q       = dot (vec4(rgb, 1.0), kRGBToQ);

        // Calculate the hue and chroma
        highp float   hueResult = atan (Q, I);
        highp float   chroma    = sqrt (I * I + Q * Q);

        // Make the user's adjustments
        hueResult += (-huee); //why negative rotation?

        // Convert back to YIQ
        Q = chroma * sin (hueResult);
        I = chroma * cos (hueResult);

        // Convert back to RGB
        highp vec4 yIQ = vec4(YPrime, I, Q, 0.0);
        rgb.r = dot (yIQ, kYIQToR);
        rgb.g = dot (yIQ, kYIQToG);
        rgb.b = dot (yIQ, kYIQToB);
    }
    
    
    //反差
    rgb = pow(rgb, vec3(gamma));
    
    //对比
    rgb = (rgb - vec3(0.5)) * contrast + vec3(0.5);

    //饱和
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    rgb = mix(greyScaleColor, rgb, saturate);

    //亮度
    rgb = rgb + vec3(brightness);
    
    
    myOutPut = vec4(rgb, 1.0);
    
}
