#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4  myOutPut;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D s_texture;
uniform sampler2D s_texture2;

void main()
{
#if __VERSION__ >= 140
    vec4 textureColor = texture(s_texture, v_texcoord);
#else
    vec4 textureColor = texture2D(s_texture, v_texcoord);
#endif
    
    float blueColor = textureColor.b * 63.0;
    
    vec2 quad1;
    quad1.y = floor(floor(blueColor) / 8.0);
    quad1.x = floor(blueColor) - (quad1.y * 8.0);
    
    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 8.0);
    quad2.x = ceil(blueColor) - (quad2.y * 8.0);
    
    vec2 texPos1;
    texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
    texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);
    
    vec2 texPos2;
    texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);
    texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);
    
    
#if __VERSION__ >= 140
    vec4 newColor1 = texture(s_texture2, texPos1);
    vec4 newColor2 = texture(s_texture2, texPos2);
#else
    vec4 newColor1 = texture2D(s_texture2, texPos1);
    vec4 newColor2 = texture2D(s_texture2, texPos2);
#endif
    
    vec4 newColor = mix(newColor1, newColor2, fract(blueColor));
    
#if __VERSION__ >= 140
    myOutPut = newColor;
//    myOutPut = vec4(1.0, 0.0, 0.0, 1.0);
#else
    gl_FragColor = newColor;
#endif
}
