#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4  myOutPut;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D s_texture;
uniform sampler2D s_texture2;

uniform float progress;

void main()
{
#if __VERSION__ >= 140
    vec4 textureColor = texture(s_texture, v_texcoord);
    vec4 textureColor2 = texture(s_texture2, v_texcoord);
#else
    vec4 textureColor = texture2D(s_texture, v_texcoord);
    vec4 textureColor2 = texture2D(s_texture2, v_texcoord);
#endif
    
    vec4 newColor;
    if (v_texcoord.x > progress) {
        newColor = textureColor;
    }else {
        newColor = textureColor2;
    }
    
#if __VERSION__ >= 140
    myOutPut = newColor;
#else
    gl_FragColor = newColor;
#endif
}
