#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out highp vec4 myOutput;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2DRect SamplerY;
uniform sampler2DRect SamplerUV;
uniform mat3 colorConversionMatrix;
uniform mat3 camsMatrix;
uniform bool isHdr;
uniform float brightness;
uniform float contrast;
uniform float saturate;
uniform float gamma;
uniform float hue;

const float lumaThreshold = 1.0;
//const float chromaThreshold = 1.114;

const float redAdjustment = 0.951;
const float greenAdjustment = 0.988;
const float blueAdjustment = 0.969;

const vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);

const highp  vec4  kRGBToYPrime = vec4 (0.299, 0.587, 0.114, 0.0);
const highp  vec4  kRGBToI     = vec4 (0.595716, -0.274453, -0.321263, 0.0);
const highp  vec4  kRGBToQ     = vec4 (0.211456, -0.522591, 0.31135, 0.0);

const highp  vec4  kYIQToR   = vec4 (1.0, 0.9563, 0.6210, 0.0);
const highp  vec4  kYIQToG   = vec4 (1.0, -0.2721, -0.6474, 0.0);
const highp  vec4  kYIQToB   = vec4 (1.0, -1.1070, 1.7046, 0.0);

float hable(float x) {
    return ((x * (0.150000*x + 0.050000) + 0.004000)/(x * (0.150000*x + 0.500000) + 0.060000)) - 0.066667;
}

void main()
{
    mediump vec3 yuv;

    vec2 uv_texcoord = vec2(v_texcoord.x * 0.5, v_texcoord.y * 0.5);
    
// Subtract constants to map the video range start at 0
//#if __VERSION__ >= 140
//    yuv.x = (texture(SamplerY, v_texcoord).r - 16.0/255.0) * lumaThreshold;
//    yuv.yz = (texture(SamplerUV, uv_texcoord).rg - vec2(0.5, 0.5)) * 1.0;
//    yuv.x = 1.000000 * vec4(texture(SamplerY, v_texcoord)).r;
//    yuv.yz = 1.000000 * vec4(texture(SamplerUV, uv_texcoord)).rg;
//#else
//    yuv.x = (texture(SamplerY, v_texcoord).r - 16.0/255.0) * lumaThreshold;
//    yuv.yz = (texture2D(SamplerUV, uv_texcoord).rg - vec2(0.5, 0.5)) * 1.0;
//#endif
//    rgb = colorConversionMatrix * yuv + vec3(-0.9729, 0.3014, -1.1334);
    
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    color.r = 1.000000 * vec4(texture(SamplerY, v_texcoord)).r;
    color.gb = 1.000000 * vec4(texture(SamplerUV, uv_texcoord)).rg;
    color = color.rgbr;
    color.rgb = colorConversionMatrix * color.rgb + vec3(-0.972945094, 0.301482677, -1.13340223);
    color.a = 1.0;
    // color mapping
    color.rgb *= vec3(1.000000);
    color.rgb *= vec3(1.000000);
    
//    rgb.r = rgb.r * 0.8761904761904762 + 24.552380952380958 / 255.0;
//    rgb.g = rgb.g * 0.8761904761904762 + 24.42857142857143 / 255.0;
//    rgb.b = rgb.b * 0.8846153846153846 + 23.15384615384616 / 255.0;
//    
    
    if (isHdr) {
        color.rgb = clamp(color.rgb, 0.0, 1.0);
        color.rgb = pow(color.rgb, vec3(1.0/78.843750));
        color.rgb = max(color.rgb - vec3(0.835938), vec3(0.0))
        / (vec3(18.851562) - vec3(18.687500) * color.rgb);
        color.rgb = pow(color.rgb, vec3(1.0/0.159302));
        color.rgb *= vec3(100.000000);
        color.rgb *= vec3(1.0/100.000000);
        color.rgb *= vec3(100.000000);
        color.rgb = camsMatrix * color.rgb;
        
        float sig = max(max(color.r, color.g), color.b);
        float sig_peak = 100.000000;
        float sig_avg = 0.250000;
        float sig_orig = sig;
        float slope = min(1.0, 0.250000 / sig_avg);
        sig *= slope;
        sig_peak *= slope;
        float luma = dot(vec3(0.2126, 0.7151, 0.0721), color.rgb);
        float coeff = max(sig - 0.180000, 1e-6) / max(sig, 1e-6);
        coeff = pow(coeff, 20.000000);
        color.rgb = mix(color.rgb, vec3(luma), coeff);
        sig = mix(sig, luma * slope, coeff);
        sig = hable(sig) / hable(sig_peak);
        sig = min(sig, 1.0);
        color.rgb *= vec3(sig / sig_orig);
        color.rgb *= vec3(1.000000);
        
        color.rgb = clamp(color.rgb, 0.0, 1.0);
        color.rgb *= vec3(1.000000);
        color.rgb = pow(color.rgb, vec3(1.0/2.2));
    }
    
    vec3 rgb = color.rgb;
    //色调
    if (hue != 0) {
        // Convert to YIQ
        highp float   YPrime  = dot (vec4(rgb, 1.0), kRGBToYPrime);
        highp float   I       = dot (vec4(rgb, 1.0), kRGBToI);
        highp float   Q       = dot (vec4(rgb, 1.0), kRGBToQ);
        
        // Calculate the hue and chroma
        highp float   hueResult = atan (Q, I);
        highp float   chroma    = sqrt (I * I + Q * Q);
        
        // Make the user's adjustments
        hueResult += (-hue); //why negative rotation?
        
        // Convert back to YIQ
        Q = chroma * sin (hueResult);
        I = chroma * cos (hueResult);
        
        // Convert back to RGB
        highp vec4 yIQ = vec4(YPrime, I, Q, 0.0);
        rgb.r = dot (yIQ, kYIQToR);
        rgb.g = dot (yIQ, kYIQToG);
        rgb.b = dot (yIQ, kYIQToB);
    }
    
    //反差
    rgb = clamp(rgb, 0.0, 1.0);
    rgb = pow(rgb, vec3(gamma));
    
    //饱和
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    rgb = mix(greyScaleColor, rgb, saturate);
    
    //对比
    rgb = (rgb - vec3(0.5)) * contrast + vec3(0.5);
    
    //亮度
    rgb = rgb + vec3(brightness);
    
    color.rgb = rgb;
#if __VERSION__ >= 140
    myOutput = color;
#else
    gl_FragColor = vec4(rgb, 1);
#endif
}
